// Versprechen-ELEMENTE. (Neu)
const Versprechen = function() {
	var args = arguments;
	var m = args.length;
	this.me = {
		value: function() {
			var cond = true;
			if(m > 0) {
				var f = args[0];
				var cond = false;
				try {
					f.call();
					cond = true;
				} catch(err) {
					cond = false;
				}
			}
			return cond;
		},
		writable: false,
		enumerable: true,
		configurable: false,
	};
};

Object.defineProperties(Versprechen.prototype, {
	'fulfilled': {
		value: false,
		writable: true,
		enumerable: true,
		configurable: false,
	},
	'child': {
		value: null,
		writable: true,
		enumerable: true,
		configurable: true,
  	},
	'hasChild': {
		value: function() {
			var cond = false;
			if(!(this.child == null) && this.child instanceof Versprechen) {
				cond = true;
			}
			return cond;
		},
		writable: false,
		enumerable: true,
		configurable: false,
  	},
	'spawn': {
		value: function(Q) {
			var self = this;
			while(self.hasChild()) {
				self = self.child;
			}
			self.child = Q;
		},
		writable: true,
		enumerable: true,	// false,
		configurable: false,
  	},
	'clone': {
		value: function(Q) {
			var self = this;
			var P = new Versprechen();
			['me','fulfilled','spawn','then','resolve'].forEach(function(key) {
				P[key] = self[key];
			});
			if(this.hasChild()) P.child = this.child.clone();
			return P;
		},
		writable: true,
		enumerable: false,
		configurable: false,
	},
	'then': {
		value: function(Q) {
			var self = this;
			var P = self.clone();
			if(Q instanceof Versprechen) {
				P.spawn(Q);
			} else if(Q instanceof Function) {
				var QQ = new Versprechen(Q);
				P = self.then(QQ);
			}
			return P;
		},
		writable:false,
		enumerable:false,
		configurable:false,
  	},
	'resolve': {
		value: function() {
			var cond = this.me.value.call(this);
			if(cond) {
				this.hasChild() ? this.fulfilled = this.child.resolve() : this.fulfilled = true;
			} else {
				this.fulfilled = false;
			}
			return this.fulfilled;
		},
		writable: false,
		enumerable: false,
		configurable: false,
	},
});

const Versprechenkette = function() {
	var args = arguments;
	var m = args.length;
	var P = new Versprechen();
	if(m>0) {
		var self = args[0];
		for(var i=1; i<m; i++) {
			if(args[i] instanceof Array) {
				var n = args[i].length;
				for(var j=0; j<n; j++) {
					P = P.then(args[i][j].bind(self));
				}
			} else {
				P = P.then(args[i].bind(self));
			}
		}
	}
	return P;
};

const resolvedVersprechenkette = function() {
	var args = arguments;
	var m = args.length;
	var P = new Versprechen();
	if(m>0) {
		var self = args[0];
		for(var i=1; i<m; i++) {
			if(args[i] instanceof Array) {
				var n = args[i].length;
				for(var j=0; j<n; j++) {
					P = P.then(args[i][j].bind(self));
				}
			} else {
				P = P.then(args[i].bind(self));
			}
		}
	}
	return P.resolve();
};

// Ticker-ELEMENTE. (Neu)
const Ticker = function(self,T,s,m,e) {
	this.me = {
		value: {
			node: self,
			dauer: T,
			start: s,
			mitte: m,
			ende: e,
		},
		writable: false,
		enumerable: false,
		configurable: false,
	};
};

Object.defineProperties(Ticker.prototype, {
	'tick': {
		value: function() {
			if(this.zeit == 0) this.set();
			this.resolve();
			this.zeit++;
		},
		writable: false,
		enumerable: false,
		configurable: false,
	},
	'initialised': {
		value: false,
		writable: true,
		enumerable: false,
		configurable: false,
	},
	'set': {
		value: function() {
			this.self = this.me.value.node;
			this.zeit = 0;
			this.end = this.me.value.dauer;
			this.startevent = this.me.value.start;
			this.normalevent = this.me.value.mitte;
			this.endevent = this.me.value.ende;
			this.initialised = true;
		},
		writable: false,
		enumerable: false,
		configurable: false,
	},
	'resolve': {
		value: function() {
			var t = this.zeit;
			var T = this.end;
			var self = this.self;
			if(t == 0) {
				this.startevent.call(self,t,T);
			} else if(t < T) {
				this.normalevent.call(self,t,T);
			} else if(t == T) {
				this.endevent.call(self,t,T);
			}
		},
		writable: false,
		enumerable: false,
		configurable: false,
	},
	'self': {
		value: this,
		writable: true,
		enumerable: true,
		configurable: false,
	},
	'zeit': {
		value: 0,
		writable: true,
		enumerable: true,
		configurable: false,
	},
	'end': {
		value: 0,
		writable: true,
		enumerable: true,
		configurable: false,
	},
	'startevent': {
		value: function() {},
		writable: true,
		enumerable: true,
		configurable: false,
	},
	'normalevent': {
		value: function(t) {},
		writable: true,
		enumerable: true,
		configurable: false,
	},
	'endevent': {
		value: function() {this.zeit = 0;},
		writable: true,
		enumerable: true,
		configurable: false,
	},
});



// FUNCTION-ELEMENTE.
Object.defineProperties(Function.prototype, {
	'asynchron': {
		value: function() {
            var f = this;
			var argliste = arguments;
			var args = [];
			Object.keys(argliste).forEach(function(key,i) {
                if(i>=1) {
                  args.push(argliste[key]);
                }
			});
			setTimeout(function() {f.apply(self,args)},0);
		},
		writable:false,
		enumerable:false,
		configurable:false,
	},
	'pingFile': {
		value: function(self) {
			var f = this;
			var ping = function() {
				f.call(self);
				return true;
			}
			var reader = new FileReader();
			reader.onerror = ping;
			reader.onload = ping;
			var blob = new Blob(['']);
			reader.readAsText(blob);
		},
		writable:false,
		enumerable:false,
		configurable:false,
	},
	'pingXML': {
		value: function(self,url) { // var url = '../xml/xml.txt';
			var f = this;
			var ping = function() {
				f.call(self);
				return true;
			}
			var xhr = new XMLHttpRequest();
			xhr.open('GET',url);
			xhr.responseType = 'blob';
			xhr.onerror = ping;
			xhr.onload = ping;
			xhr.send();
		},
		writable:false,
		enumerable:false,
		configurable:false,
	},
	'verkettet': {
		value: function() {
			var f = this;
			if(arguments.length > 1) {
				var self = null;
				var richtung = false;
				if(arguments.length > 4) {
					var self = arguments[0];
					var neutral = arguments[1];
					var id = arguments[2];
					var args = arguments[3];
					var richtung = arguments[3];
				} else if(arguments.length > 3) {
					var self = arguments[0];
					var neutral = arguments[1];
					var id = arguments[2];
					var args = arguments[3];
				} else {
					var neutral = arguments[0];
					var id = arguments[1];
					var args = arguments[2];
				}
				var n = args.length;
				if(n==0) {
					return neutral;
				} else if(n==1) {
					return id(args[0]);
				} else {
					if(richtung) {
						// von links nach rechts lesen
						// d. h. linkes Glied = äußeres Glied
						//			 rechtes Glied = inneres Glied
						var x = id(args[n-1]);
						for(var k=n-1; k>0; k--) {
							x = f.call(self,id(args[k-1]),x);
						}
					} else {
						// von rechts nach links lesen
						// d. h. linkes Glied = inneres Glied
						//			 rechtes Glied = äußeres Glied
						var x = id(args[0]);
						for(var k=1; k<n; k++) {
							x = f.call(self,x,id(args[k]));
						}
					}
					return x;
				}
			} else {
				return null;
			}
		},
		writable:false,
		enumerable:false,
		configurable:false,
	},
});


// NODE-ELEMENTE.
Object.defineProperties(Node.prototype, {
	'getSichtbarkeit': {
		value: function(child) {
			var outerV = this.clientHeight;
			var outerH = this.clientWidth;
			var relTop = child.offsetTop-(this.offsetTop+this.scrollTop+this.clientTop);
			var innerV = child.offsetHeight;
			var relBot = relTop + innerV;
			var relLeft = child.offsetLeft-(this.offsetLeft+this.scrollLeft+this.clientLeft);
			var innerH = child.offsetWidth;
			var relRight = relLeft + innerH;
			var sichtbar = {
				top: (0 <= relTop) && (relTop <= outerV),
				bot: (0 <= relBot) && (relBot <= outerV),
				left: (0 <= relLeft) && (relLeft <= outerH),
				right: (0 <= relRight) && (relRight <= outerH),
			};
			sichtbar.total = {
				vertical: sichtbar.top && sichtbar.bot,
				horizontal: sichtbar.left && sichtbar.right,
			};
			sichtbar.part = {
				top: !sichtbar.top && sichtbar.bot,
				bot: sichtbar.top && !sichtbar.bot,
				verticalin: (sichtbar.top || sichtbar.bot) && !sichtbar.total.vertical,
				verticalout: (relTop <= 0) && (outerV <= relBot) && !sichtbar.total.vertical,
				left: !sichtbar.left && sichtbar.right,
				right: sichtbar.left && !sichtbar.right,
				horizontalin: (sichtbar.left || sichtbar.right) && !sichtbar.total.horizontal,
				horizontalout: (relLeft <= 0) && (outerH <= relRight) && !sichtbar.total.horizontal,
			};
			return sichtbar;
		},
		writable:false,
		enumerable:false,
		configurable:false,
	},
	'makeAsynchronEventListener': {
		value: function() {
			var self = this; // der Node
			var argliste = arguments;
			if(argliste.length >= 2) {
				var args = [];
				Object.keys(argliste).forEach(function(key,i) {
					args.push(argliste[key]);
				});
				if(args.length < 3) {
					args[2] = false;
				}
				var typ = args[0];
				var f = args[1];
				args[1] = function(event) {
					prozess.pre.call(self,event); //prozess.pre.asynchron(self,event);
					f.call(self,event); //f.asynchron(self,event);
					prozess.post.call(self,event); //prozess.post.asynchron(self,event);
				};
				self['on'+typ] = args[1].bind(self);
			} else {
				console.log('Error bei der Ausführung von '+this+'.addAsynchronEventListener!');
				console.log('Argumente müssen der Form    EVENT, FKT [, ]    sein.');
			}
		},
		writable:false,
		enumerable:false,
		configurable:false,
	},
	'addAsynchronEventListener': {
		value: function() {
			var self = this; // der Node
			var argliste = arguments;
			if(argliste.length >= 2) {
				var args = [];
				Object.keys(argliste).forEach(function(key,i) {
					args.push(argliste[key]);
				});
				if(args.length < 3) {
					args[2] = false;
				}
				var f = args[1];
				args[1] = function(event) {
					prozess.pre.call(self,event); //prozess.pre.asynchron(self,event);
					f.call(self,event); //f.asynchron(self,event);
					prozess.post.call(self,event); //prozess.post.asynchron(self,event);
				};
				self.addEventListener.apply(self,args);
			} else {
				console.log('Error bei der Ausführung von '+this+'.addAsynchronEventListener!');
				console.log('Argument müssen der Form    EVENT, FKT [, ]    sein.');
			}
		},
		writable:false,
		enumerable:false,
		configurable:false,
	},
	'removeAllChildNodes': {
		value: function() {
			while(this.hasChildNodes()) {
				var child = this.lastChild;
				this.removeChild(child);
			}
		},
		writable:false,
		enumerable:false,
		configurable:false,
	},
	'insertAfter': {
		value: function(node) {
			this.parentNode.insertBefore(node,this.nextSibling);
		},
		writable:false,
		enumerable:false,
		configurable:false,
	},
	'removeClass': {
		value: function(c) {
			str = this.className;
			str = str.split(' ');
			str.forEach(function(element,idx,array) {
				if(element === c) {
					array.splice(idx,1);
				}
			});
			this.className = str.join(' ');
			return this;
		},
		writable:false,
		enumerable:false,
		configurable:false,
	},
	'aufklappen': {
		value: function() {
			if(this.hasAttribute('aria-expanded')) {
				this.ariaExpanded = true;
				if(this.parentNode) {this.parentNode.aufklappen()};
			}
		},
		writable:false,
		enumerable:false,
		configurable:false,
	},
	'documentOffsetTop': {
		value: function() {
			var y = 0;
			y = this.offsetTop;
			if(this.offsetParent) {y += this.offsetParent.documentOffsetTop()};
			return y;
		},
		writable:false,
		enumerable:false,
		configurable:false,
	},
	'scrollIntoViewCenter': {
		value: function() {
			var y = this.documentOffsetTop()-window.innerHeight/2;
			if(y>0) {window.scrollTo(0,y)};
		},
		writable:false,
		enumerable:false,
		configurable:false,
	},
});

// NODELIST-ELEMENTE.
Object.defineProperties(NodeList.prototype, {
	'cloneNodeList': {
		value: function() {
			var list = [];
			for(var i=0; i<this.length; i++) {
				list.push(this[i].cloneNode(true));
			}
			return list;
		},
		writable:false,
		enumerable:false,
		configurable:false,
	}
});

// HTML-ELEMENTE.
Object.defineProperties(HTMLElement.prototype, {
	'removeClass': {
		value: function(remove) {
			var newClassName = [];
			var classes = this.className.split(' ');
			for(var i=0; i<classes.length; i++) {
					if(classes[i] !== remove) {
							newClassName.push(classes[i]);
					}
			}
			this.className = newClassName.join(' ');
		},
		writable:false,
		enumerable:false,
		configurable:false,
	}
});

// STRING-ELEMENTE.
Object.defineProperties(String.prototype, {
	'toRegExp': {
		value: function() {
			return this.replace(/[\-\[\]\/\{\}\(\)\*\+\?\.\\\^\$\|]/g, '\\$&');
		},
		writable:false,
		enumerable:false,
		configurable:false,
	},
	'autotranslateGoogle': {
		// Sprachkürzel: https://cloud.google.com/translate/docs/languages
		value: function(from,to,proc,procerror) {
			var self = this;
			//var text = encodeURI(self);	// Codiert das &-Zeichen nicht!!
			var text = decodeURI(self);
			text = text.replace(/\&/g,function() {return '\\&';});
			var url = {};
			url.root = 'https://translate.googleapis.com/translate_a/single';
			var qry = {
				'client': ['gtx'],
				'sl': [from],
				'tl': [to],
				'dt': ['t'],
				'q': [text],
			};
			var array = [];
			Object.keys(qry).forEach(function(key) {
				array.push(key+'='+qry[key].join('+'));
			});
			url.q = url.root+'?'+array.join('&');

			var xhr = new XMLHttpRequest();
			xhr.open('GET',url.q);
			xhr.responseType = 'jsonp';
			xhr.onload = function(result) {
				if(this.readyState == 4 && this.status == 200) {
					try {
						var w = this.responseText;
						var cond = true;
						var regex = /\,\,/g;
						while(cond) {
							cond = regex.test(w);
							w = w.replace(regex,function(match) {return ',null,';});
						}
						w = JSON.parse(w);
						out = [w[0][0][0]];
					} catch(err) {
						out = [];
					}
					for(var k = out.length-1; k>=0; k--) {
						if(out[k] == '') {
							out.splice(k,1);
						}
					}
					proc.call(self,out);
				} else {
					console.log('Ein Problem bei der Übersetzung von: {'+self+'} ist aufgetreten.');
					procerror.call(self);
				}
			};
			xhr.onerror = function() {
				console.log('Ein Fehler ist bei der Abrufung von '+url.root+' aufgetreten.');
				procerror.call(self);
			};
			xhr.send();
		},
		writable:false,
		enumerable:false,
		configurable:false,
	},
	'autotranslateLinguee': {
		value: function() {
		},
		writable:false,
		enumerable:false,
		configurable:false,
	},
	'autotranslateYandex': {
		// Sprachkürzel: https://tech.yandex.com/translate/doc/dg/concepts/api-overview-docpage/#languages
		value: function(from,to,api,proc,procerror) {
			var self = this;
			//var text = encodeURI(self);	// Codiert das &-Zeichen nicht!!
			var text = encodeURIComponent(self)
			var url = {};
			url.root = 'https://translate.yandex.net/api/v1.5/tr.json/translate';
			var qry = {
				'key': [api],
				'text': [text],
				'lang': [from+'-'+to],
				'format': ['plain'],
				'options': ['1'],
				//'callback': ['callbackfkt'],
			};
			var array = [];
			Object.keys(qry).forEach(function(key) {
				array.push(key+'='+qry[key].join('+'));
			});
			url.q = url.root+'?'+array.join('&');

			var xhr = new XMLHttpRequest();
			xhr.open('GET',url.q);
			xhr.responseType = 'jsonp';
			xhr.onload = function(result) {
				if(this.readyState == 4 && this.status == 200) {
					try {
						var w = this.responseText;
						var cond = true;
						var regex = /\,\,/g;
						while(cond) {
							cond = regex.test(w);
							w = w.replace(regex,function(match) {return ',null,';});
						}
						w = JSON.parse(w);
						out = w['text'];
					} catch(err) {
						out = [];
					}
					for(var k = out.length-1; k>=0; k--) {
						if(out[k] == '') {
							out.splice(k,1);
						}
					}
					proc.call(self,out);
				} else {
					console.log('Ein Problem bei der Übersetzung von: {'+self+'} ist aufgetreten.');
					procerror.call(self);
				}
			};
			xhr.onerror = function() {
				console.log('Ein Fehler ist bei der Abrufung von '+url.root+' aufgetreten.');
				procerror.call(self);
			};
			xhr.send();
		},
		writable:false,
		enumerable:false,
		configurable:false,
	},
	'toGrossschreibung': {
		value: function() {
			var str = this.toLowerCase();
			str = str.replace(/\b\w/g,function(match){return match.toUpperCase();});
			return str;
		},
		writable:false,
		enumerable:false,
		configurable:false,
	},
	'getMatches': {
		value: function(regex_muster) {
			tokens = [];
			this.replace(regex_muster,function(match,token) {
				tokens.push(token);
			});
			return tokens;
		},
		writable:false,
		enumerable:false,
		configurable:false,
	},
	'googleKeywordReinigen_simple': {
		value: function() {
			var analyse = this.googleKeywordReinigen();
			var extrakt = {wort: [], encode: null};
			if(analyse.length > 0) {
				extrakt.wort = analyse.projizierung('wort');
				extrakt.encode = analyse[0].encode;
			}
			return(extrakt);
		},
		writable:false,
		enumerable:false,
		configurable:false,
	},
	'googleKeywordReinigen': {
		value: function() {
			var eingabe = this.stripLeerzeichen();
			var analyse = [];
			while(eingabe.length>0) {
				var cond = false;
				var i = 0;
				var wort = '';
				var encode = 'id';
				var kkeys = Object.keys(google_muster);
				while(!cond && i<kkeys.length) {
					if(!(kkeys[i] == 'id')) {
						el = google_muster[kkeys[i]];
						if(el.decode.test(eingabe)) {
							cond = true;
							eingabe.replace(el.decode,function(match,$0,$1,$2,$3) {
								wort = $0;
								if($3) {
									eingabe = $3;
								} else {
									eingabe = '';
								}
							});
							encode = kkeys[i];
						};
					}
					i++;
				}
				if(!cond) {
					var obj = eingabe.splitatLeerzeichen();
					wort = obj.left;
					eingabe = obj.right;
				}
				// Füge nur dann hinzu, wenn Wort nicht leer ist.
				if(wort.length>0) {
					analyse.push({wort: wort, encode:encode});
				}
			}
			return(analyse);
		},
		writable:false,
		enumerable:false,
		configurable:false,
	},
	'capitaliseSatz': {
		value: function() {
			return this.replace(/^(((?!\w)|(?=\d))(.((?!\w)|(?=\d)))*.|)(\w)/, function(_,$0,_,_,_,$1) {return $0+$1.toUpperCase();});
		},
		writable: false,
		enumerable: false,
		configurable: false,
	},	
	'cleanSatz': {
		value: function(gross) {
			var satz = this;
			var vor = '\\¡|\\¿';
			var nach = '\\.|\\!|\\?|\\,|\\:|\\;';
			satz = satz.replace(/(  +)/g, function(_,$0) {return ' ';});	// doppelte Leerzeichen durch einfache ersetzen
			satz = satz.replace(new RegExp('('+vor+')\\s+','g'), function(_,$0) {return $0;});
			satz = satz.replace(new RegExp('\\s+('+nach+')','g'), function(_,$0) {return $0;});
			if(gross) satz = satz.capitaliseSatz();
			return satz;
		},
		writable: false,
		enumerable: false,
		configurable: false,
	},
	'getnextSatz': {
		value: function() {
			var str = this;
			var satzanfang = '\\¡|\\¿|\\„|\\“|\\"|\\”|\\«|\\»';
			var satzende = '\\.|\\!|\\?|\\“|\\"|\\”|\\«|\\»';
			var anfang = '';
			var mitte = str;
			var ende = '';
			var rest = '';
            var regex = new RegExp('^\\s*((?=('+satzanfang+'))(.(?=(\\s|'+satzanfang+')))*\\S|)\\s*((.(?!('+satzende+')))*\\S|)\\s*((?=('+satzende+'))(.(?=('+satzende+')))*\\S|$)\\s*(.*\\S|)\\s*$');
            str.replace(regex,function(_,$0,_,_,_,$1,_,_,$2,_,_,_,$3) { // 1, 5, 8, 12.
               anfang = $0;
               mitte = $1;
               ende = $2;
               rest = $3;
            });
            if(anfang == null) anfang = '';
            if(mitte == null) mitte = '';
            if(ende == null) ende = '';
			if(rest == null) rest = '';
			mitte = mitte.replace(/\s\s+/g,function() {return ' ';});
			return {anfang: anfang, mitte: mitte, ende: ende, rest: rest};
		},
		writable: false,
		enumerable: false,
		configurable: false,
	},
	'getClauses': {
		value: function(gross) {
			var eingabe = this;
			var analyse = [];
			while(eingabe.length > 0) {
				var obj = eingabe.getnextSatz();
				var satz = (obj.anfang+obj.mitte+obj.ende).cleanSatz(gross);
				analyse.push(satz);
				eingabe = obj.rest;
			}
			return(analyse);
		},
		writable:false,
		enumerable:false,
		configurable:false,
	},
	'analysenextSatz': {
		value: function() {
			var str = this;
			var satzanfang = '\\¡|\\¿|\\„|\\“|\\"|\\”|\\«|\\»';
			var satzende = '\\.|\\!|\\?|\\“|\\"|\\”|\\«|\\»';
			var trennzeichen = '\\,|\\:|\\;';
			var anfang = '';
			var mitte = '';
			var ende = '';
			var rest = '';
            var regex = new RegExp('^\\s*((?=('+satzanfang+'))(.(?=(\\s|'+satzanfang+')))*\\S|)\\s*((.(?!('+satzende+')))*\\S|)\\s*((?=('+satzende+'))(.(?=('+satzende+')))*\\S|$)\\s*(.*\\S|)\\s*$');
            str.replace(regex,function(_,$0,_,_,_,$1,_,_,$2,_,_,_,$3) { // 1, 5, 8, 12.
               anfang = $0;
               mitte = $1;
               ende = $2;
               rest = $3;
            });
			if(mitte == null) {
				body = [];
			} else {
				var regex = new RegExp('(\\s|'+trennzeichen+')');
				var body = mitte.split(regex);
				for(var k=body.length-1; k>=0; k--) {
					if(/^\s*$/.test(body[k])) body.splice(k,1);
				}
			}
            if(anfang == null) anfang = '';
            if(ende == null) ende = '';
			if(rest == null) rest = '';
			return {anfang: anfang, body: body, ende: ende, rest: rest};
		},
		writable: false,
		enumerable: false,
		configurable: false,
	},
	'analyseClauses': {
		value: function(gross) {
			var eingabe = this;
			var analyse = [];
			var regex = new RegExp(/^\s*((.(?!(\s*[\!\.\?]+(\s|$))))*(.|$))?(\s*(([\!\.\?]+)?(\s|$)|$)?\s*|$)(.*?)$/);
			while(eingabe.length > 0) {
				var obj = eingabe.analysenextSatz();
				var words = [];
				if(obj.anfang.length > 0) words.push(obj.anfang);
				words = words.concat(obj.body);
				if(obj.ende.length > 0) words.push(obj.ende);
				analyse.push(words);
				eingabe = obj.rest;
			}
			return(analyse);
		},
		writable:false,
		enumerable:false,
		configurable:false,
	},
	'removeOuterbraces': {
		value: function(str) {
			str = this;
			regex=[];
			['[]','()','{}'].forEach(function(element) {
				var r = new RegExp('^'+'\\'+element[0]+'(.*?)'+'\\'+element[1]+'$');
				regex.push(r);
			});
			var cond = true;
			while(cond) {
				cond = false;
				regex.forEach(function(element) {
					if(element.test(str)) {
						cond = true;
						str = str.replace(element,function(match,tok) {return tok;});
					}
				});
			}
			return str;
		},
		writable:false,
		enumerable:false,
		configurable:false,
	},
	'splitatLeerzeichen': {
		value: function() {
			var suff = this.stripLeerzeichen();
			var idx = 0;
			var cond = false;
			while(suff.length>0 && !cond) {
				if(/^\s/.test(suff)) {
					cond = true;
				} else {
					suff = suff.slice(1);
					idx = idx+1;
				}
			}
			var pref = this.substring(0,idx);
			suff = suff.stripLeerzeichen();
			return({left:pref, right:suff});
		},
		writable:false,
		enumerable:false,
		configurable:false,
	},
	'stripLeerzeichen': {
		value: function() {
			var str = this;
			while(/^\s/.test(str)) {
				str = str.slice(1);
			}
			return(str);
		},
		writable:false,
		enumerable:false,
		configurable:false,
	},
	'stripHTTPWWW': {
		value: function() {
			var url = this;
			var regex = new RegExp(/^[a-zA-Z0-9]*:\/\/(.)*/);
			if(regex.test(url)) {
				url = url.getMatches(/^.*?:\/\/(.*)/);
				url = url[0].replace(/^www[\d]*\./,'');
			} else {
				url = '';
			}
			return url;
		},
		writable:false,
		enumerable:false,
		configurable:false,
	},
	'getDomain': {
		value: function() {
			var url = this.stripHTTPWWW();
			url = url.getMatches(/^(.*?)(\/|$)/);
			url = url[0];
			return url;
		},
		writable:false,
		enumerable:false,
		configurable:false,
	},
	'hasDomain': {
		value: function(dom) {
			var url = this.stripHTTPWWW();
			return(url.indexOf(dom) == 0);
		},
		writable:false,
		enumerable:false,
		configurable:false,
	},
	'parseURLparams': {
		value: function() {
			var args = Array.prototype.slice.call(arguments, 0);
			sauber = false;
			if(args.length > 0) {
				if(typeof(args[0]) == 'boolean') {
					sauber = args[0];
				}
			}
			var params = {};
			var queryStart = this.indexOf('?') + 1;
			var queryEnd = Math.max(this.indexOf('#'),this.length) + 1;
			var query = this.slice(queryStart, queryEnd - 1);
			query = query.replace(/(\w+?)\((.*?)\)/g, function(match,tok1,tok2) {
						return tok1+'='+tok2+' &';
				});
			query = query.replace(/\+/g,' ');
			var pairs = query.split('&');
			pairs.forEach(function(element,idx) {
					if(element=='') {
						pairs.splice(idx,1);
					};
			});
			for (var i = 0; i < pairs.length; i++) {
					var attribut = pairs[i].split('=', 2);
					if(attribut.length > 0) {
						if(attribut.length == 1 && i == 0) {
							var key = '?';
							var val = decodeURIComponent(attribut[0]);
						} else if(attribut.length == 2) {
							var key = decodeURIComponent(attribut[0]);
							var val = decodeURIComponent(attribut[1]);
						}
						if(sauber) {val = val.removeOuterbraces();}
						if(!params.hasOwnProperty(key)) {params[key] = [];}
						params[key].push(val);
					}
			}
			if(args.length==1) {
				if(typeof(args[0])=='string') {
					key = args[0];
					if(params.hasOwnProperty(key)) {
						params = params[key];
					} else {
						params = false;
					}
				}
			} else if(args.length==2) {
				if(typeof(args[0])=='boolean' && typeof(args[1])=='string') {
					key = args[1];
					if(params.hasOwnProperty(key)) {
						params = params[key];
					} else {
						params = false;
					}
				}
			}
			return params;
		},
		writable:false,
		enumerable:false,
		configurable:false,
	},
	'invertColour': {
		value: function(typ) {
			var col = new RGBcolour(this);
			['r','g','b'].forEach(function(element) {
				col[element] = 255-col[element];
			});
			if(typ === 'rgb') {
				col = col.toRGB();
			} else if( typ === 'hex') {
				col = col.toHex();
			} else {
				col = col.toHex();
			}
			return col;
		},
		writable:false,
		enumerable:false,
		configurable:false,
	},
	'CSVgetJSON': {
		value: function(trennungszeichen) {
			var zeilen = this.split(/\r\n|\n/);
			var rows = [];
			var n = zeilen.length;
			if(n>0) {
				var head = zeilen[0].split(trennungszeichen);
				var m = head.length;
				for(var i=1; i<n; i++) {
					rows[i-1] = {};
					var zelle = zeilen[i].split(trennungszeichen);
					for(var j=0; j<Math.min(m,zelle.length); j++) {
						rows[i-1][head[j]] = zelle[j];
					}
				}
				return rows;
			} else {
				return [];
			}
		},
		writable:false,
		enumerable:false,
		configurable:false,
	},
	'CSVgetMatrix': {
		value: function(trennungszeichen) {
			var zeilen = this.split(/\r\n|\n/);
			var rows = [];
			var cols = [];
			zeilen.forEach(function(zeile,i) {
				//var zellen = zeile.split(/;|,/);
				var zellen = zeile.split(trennungszeichen);
				if(zellen.length > 0) {
					rows.push([]);
					zellen.forEach(function(zelle,j) {
						rows[i].push(zelle);
						if(j>=cols.length) {
							cols.push([]);
						}
						cols[j].push(zelle);
					});
				}
			});
			if(arguments.length>1) {
				var opt = arguments[1];
				if(/^((R|r)ow(|s)|(Z|z)eile(|n))$/.test(opt)) {
					return rows;
				} else if(/^((C|c)ol(|umn)(|s)|(S|s)palt(|n))$/.test(opt)) {
					return cols;
				}
			}
			return {row:rows, col:cols};
		},
		writable:false,
		enumerable:false,
		configurable:false,
	},
});


// OBJECT-ELEMENTE.
Object.defineProperties(Object.prototype, {
	// FILE-ELEMENT (quasi...).
	'readTXTDatei': {
		value: function(self,fkt) {
			var reader = new FileReader();
			reader.onerror = function(event) {
				if(event.target.error.name == 'NotReadableError') {
					alert('Fehler: Datei lässt sich sich einlesen.');
				};
			};
			reader.onload = function(event) {
				var data = event.target.result;
				fkt.call(self,data);
			};
			reader.readAsText(this,'UTF-8');
		},
		writable:false,
		enumerable:false,
		configurable:false,
	},
	'readCSVXLSXDatei': {
		value: function(self,ext,trennungszeichen,fkt) {
			var reader = new FileReader();
			reader.onerror = function(event) {
				if(event.target.error.name == 'NotReadableError') {
					alert('Fehler: Datei lässt sich sich einlesen.');
				};
			};
			if(ext == '.csv') {
				reader.onload = function(event) {
					var data = event.target.result;
					var blatt = data.CSVgetJSON(trennungszeichen).CSVJSONgetListen();
					var workbook = {'': blatt};
					fkt.call(self,workbook);
				};
				reader.readAsText(this,'UTF-8');
			} else if(ext == '.xlsx') {
				reader.onload = function(event) {
					var data = event.target.result;
					worker = new Worker(js_worker_xlsx);
					worker.postMessage({d:data, b:true});
					worker.onmessage = function(ev) {
						switch(ev.data.t) {
							case 'ready':
								break;
							case 'e':
								console.error(ev.data.d);
								break;
							default:
								var trennungszeichen = ',';
								var workbook_roh = JSON.parse(ev.data.d);
								var workbook = {};
								workbook_roh.SheetNames.forEach(function(sheet) {
									workbook[sheet] = workbook_roh.Sheets[sheet].JSONgetListen();
								});
								fkt.call(self,workbook);
								break;
						}
					};
				};
				reader.readAsBinaryString(this,'UTF-8');
			}
		},
		writable:false,
		enumerable:false,
		configurable:false,
	},
	'JSONgetList': {
		value: function(head) {
			// head: als regex-Variable
			var cols = this;
			var list = null;
			var cond = false;
			var doppelt = false;
			var h = Object.keys(cols);
			var i = 0;
			while(i<h.length && (!cond || !doppelt)) {
				if(head.test(h[i])) {
					if(!cond) {
						list = cols[h[i]];
						cond = true;
					} else {
						list = null;
						doppelt = true;
					}
				}
				i++;
			}
			return(list);
		},
		writable:false,
		enumerable:false,
		configurable:false,
	},
	'JSONgetListen': {
		value: function() {
			var blatt = this;
			var heads = [];
			var range = XLSX.utils.decode_range(blatt['!ref']);
			var R = range.s.r;
			for(var C = range.s.c; C <= range.e.c; ++C) {
				var cell = blatt[XLSX.utils.encode_cell({c:C, r:R})];
				var hdr = 'UNKNOWN '+C;
				if(cell && cell.t) hdr = XLSX.utils.format_cell(cell);
				heads.push(hdr);
			}
			var rows = XLSX.utils.sheet_to_row_object_array(blatt);
			var n = rows.length;
			var cols = {};
			heads.forEach(function(h) {
				var leer = '';	// evtl. vom Spaltentypen abhängig...
				cols[h] = [];
				rows.forEach(function(row) {
					if(row.hasOwnProperty(h)) {
						cols[h].push(row[h]);
					} else {
						cols[h].push(leer);
					}
				});
			});
			return(cols);
		},
		writable:false,
		enumerable:false,
		configurable:false,
	},
	'JSONhasList': {
		value: function(head) {
			// head: als regex-Variable
			var cols = this;
			var list = null;
			var cond = false;
			var doppelt = false;
			var h = Object.keys(cols);
			var i = 0;
			while(i<h.length && (!cond || !doppelt)) {
				if(head.test(h[i])) {
					if(!cond) {
						cond = true;
					} else {
						doppelt = true;
					}
				}
				i++;
			}
			return(cond && !doppelt);
		},
		writable:false,
		enumerable:false,
		configurable:false,
	},
	'injectAt': {
		value: function(key,x,idx) {
			//    this = 0 1 2 ... idx-1 idx  idx+1 ...
			//           a b c ...    d   e      f  ...
			//  output = 0 1 2 ... idx-1 idx  idx+1 idx+2 ...
			//           a b c ...    d   X     e     f   ...
			var self = this;
			var neu = {};
			var kkeys = Object.keys(self);
            var i;
            idx = Math.min(idx,kkeys.length);
			for(i=0; i<idx; i++) {
				neu[kkeys[i]] = self[kkeys[i]];
			}
			neu[key] = x;
			for(i=idx; i<kkeys.length; i++) {
				neu[kkeys[i]] = self[kkeys[i]];
			}
			return neu;
		},
		writable:false,
		enumerable:false,
		configurable:false,
	},
	'runAttribute': {
		value: function(self,key) {
			if(this.hasOwnProperty(key)) {
				obj = this[key];
				if(obj instanceof Function) {
					var args = Array.prototype.slice.call(arguments, 2);
					obj.apply(self,args);
				}
			}
		},
		writable:false,
		enumerable:false,
		configurable:false,
	},
	'showAttribute': {
		value: function(self,key) {
			if(this.hasOwnProperty(key)) {
				obj = this[key];
				if(obj instanceof Function) {
					var args = Array.prototype.slice.call(arguments, 2);
					return obj.apply(self,args);
				} else {
					return obj;
				}
			}
		},
		writable:false,
		enumerable:false,
		configurable:false,
	},
	'isEqual': {
		value: function(obj) {
			var self = this;
			cond = true;
			Object.keys(self).forEach(function(key) {
				if(obj.hasOwnProperty(key)) {
					if(!(self[key] === obj[key])) {
						cond = false;
					}
				} else {
					cond = false;
				}
			});
			return cond;
		},
		writable:false,
		enumerable:false,
		configurable:false,
	},
	'countUp': {
		value: function(func) {
			var self = this;
			var count = 0;
			Object.keys(self).forEach(function(key) {
				if(func(self[key])) {
					count++;
				}
			});
			return count;
		},
		writable:false,
		enumerable:false,
		configurable:false,
	},
	'ausfuehren': {
		value: function(cond,action) {
			var self = this;
			Object.keys(self).forEach(function(key) {
				if(cond(self[key])) {
					self[key] = action(self[key]);
				}
			});
			return self;
		},
		writable:false,
		enumerable:false,
		configurable:false,
	},
});


// ARRAY-ELEMENTE.
Object.defineProperties(Array.prototype, {
    'arrayproduct': {
		value: function() {
			var self = this;
			var out = [];
            if(self.length > 1) {
              var x = self[0];
              var y = self.slice(1).arrayproduct();
              x.forEach(function(xx) {
                y.forEach(function(yy) {
                  var z = [xx].concat(yy);
                  z = JSON.parse(JSON.stringify(z));
                  out.push(z);
                });
              });
            } else if(self.length == 1) {
              var out = [];
              self[0].forEach(function(xx) {
                out.push([xx])
              });
            } else {
              out = [];
            }
            return out;
        },
		writable:false,
		enumerable:false,
		configurable:false, 
    },
	'vervielfachen': {
		value: function(fromto) {
			var self = this;
			var out = [];
            self.forEach(function(x,i) {
				var b = JSON.stringify(x);
				if(fromto.hasOwnProperty(b)) {
					var y = fromto[b].slice(0);
					if(y == null || y.length == 0) {
						self[i] = [x.slice(0)];
					} else {
						y.forEach(function(yy,j) {
							y[j] = yy.split(' ');
						});
						self[i] = y;
					}
				} else {
					self[i] = [x.slice(0)];
				}
            });
			return self.arrayproduct();
		},
		writable:false,
		enumerable:false,
		configurable:false,
	},
	'projizierung': {
		value: function(key) {
			var self = this;
			var f = function(x,y) {return x.concat(y);};
			var id = function(x) {return [x[key]];};
			var sel = f.verkettet(null,[],id,self);
			return sel;
		},
		writable:false,
		enumerable:false,
		configurable:false,
	},
	'IntervallUeberdeckung': {
		value: function(opt) {
			var ind = this.sort(function(x,y) {return x-y;});
			var I = [];
			var k = 0;
			var j,jj;
			for(var i=0; i<ind.length; i++) {
				jj = ind[i];
				if(i == 0) {
					I[k] = [jj];
				} else if(jj == j+1) {
					I[k].push(jj);
				} else {
					k++;
					I.push([jj]);
				}
				j = jj;
			}
			// opt = true: entferne alle Partition-Elemente, die aus einem Block bestehen.
			// opt = false: behalte diese.
			if(opt) {
				for(var i=I.length-1; i>=0; i--) {
					if(I[i].length <= 1) I.splice(i,1);
				}
			}
			return(I);
		},
		writable:false,
		enumerable:false,
		configurable:false,
	},
	'mergeBlocks': {
		value: function(I) {
			var blocks = this;
			var J = [];
			var J_neu = [];
			var i = 0;
			var idx = 0;
			I.forEach(function(intervall) {
				j = intervall[0];
				for(var k=i; k<j; k++) {
					J.push(blocks[k]);
					idx++;
				}
				var block = [];
				intervall.forEach(function(k) {
					block = block.concat(blocks[k]);
					i = k+1;
				});
				J.push(block.slice());
				J_neu.push(idx);
				idx++;
			});
			j = blocks.length;
			for(var k=i; k<j; k++) {
				J.push(blocks[k].slice());
				idx++;
			}
			return({partition: J, neu: J_neu});
		},
		writable:false,
		enumerable:false,
		configurable:false,
	},
	'injectAt': {
		value: function(x,i) {
			var self = this;
			self.splice.apply(self,[i,0].concat(x));
			return self;
		},
		writable:false,
		enumerable:false,
		configurable:false,
	},
	'findeErstes': {
		value: function(func) {
			var self = this.slice(0);
			var cond = false;
			var idx = 0;
			while(!cond && idx<self.length) {
				var element = self[idx];
				if(func(element)) {
					return idx;
				}
				idx++;
			}
			return -1;
		},
		writable:false,
		enumerable:false,
		configurable:false,
	},
	'getAlle': {
		value: function(func) {
			var self = this.slice(0);
			for(i=self.length-1; i>0; i--) {
				var element = self[i];
				if(!func(element)) {
					self.splice(i, 1);
				}
			}
			return self;
		},
		writable:false,
		enumerable:false,
		configurable:false,
	},
	'entferneAlle': {
		value: function(func) {
			var self = this;
			for(i=self.length-1; i>0; i--) {
				var element = self[i];
				if(func(element)) {
					self.splice(i, 1);
				}
			}
		},
		writable:false,
		enumerable:false,
		configurable:false,
	},
	'countUp': {
		value: function(func) {
			var self = this;
			var count = 0;
			self.forEach(function(element) {
				if(func(element)) {
					count++;
				}
			});
			return count;
		},
		writable:false,
		enumerable:false,
		configurable:false,
	},
	'getAllObj': {
		value: function(obj) {
			return this.getAlle(function(element) {
				return element.isEqual(obj);
			});
		},
		writable:false,
		enumerable:false,
		configurable:false,
	},
	'removeAllObj': {
		value: function(obj) {
			this.entferneAlle(function(element) {
				return element.isEqual(obj);
			});
		},
		writable:false,
		enumerable:false,
		configurable:false,
	},
	'indexOfObj': {
		value: function(obj) {
			return this.findeErstes(function(element) {
				return element.isEqual(obj);
			});
		},
		writable:false,
		enumerable:false,
		configurable:false,
	},
	'containsObj': {
		value: function(obj) {
			return(!(this.indexOfObj(obj) == -1));
		},
		writable:false,
		enumerable:false,
		configurable:false,
	},
	'CSVJSONgetListen': {
		value: function() {
			var rows = this;
			var n = rows.length;
					var cols = {};
			var head = new Set();
			rows.forEach(function(row) {
				var h = Object.keys(row);
				h.forEach(function(x) {
					head.add(x);
				});
			});
			head = Array.from(head);
			head.forEach(function(h) {
				var leer = '';	// evtl. vom Spaltentypen abhängig...
				cols[h] = [];
				rows.forEach(function(row) {
					if(row.hasOwnProperty(h)) {
						cols[h].push(row[h]);
					} else {
						cols[h].push(leer);
					}
				});
			});
			return(cols);
		},
		writable:false,
		enumerable:false,
		configurable:false,
	},
	'CSVgetListen': {
		value: function() {
			listen = [];
			this.forEach(function(array) {
				if(array.length>0) {
					var head = array[0];
					var list = array;
					list.splice(0,1);
					if(head.length>0) {
						listen.push({head: head, list: list});
					}
				}
			});
			return(listen);
		},
		writable:false,
		enumerable:false,
		configurable:false,
	},
	'CSVgetList': {
		value: function(head) {
		// head: als regex-Variable
			var listen = this;
			var list = null;
			var cond = false;
			var doppelt = false;
			var i=0;
			while(i<listen.length && (!cond || !doppelt)) {
				if(head.test(listen[i].head)) {
					if(!cond) {
						list = listen[i].list;
						cond = true;
					} else {
						list = null;
						doppelt = true;
					}
				}
				i++;
			}
			return(list);
		},
		writable:false,
		enumerable:false,
		configurable:false,
	},
	'CSVhasList': {
		value: function(head) {
			var listen = this;
			var list = null;
			var cond = false;
			var doppelt = false;
			var i=0;
			while(i<listen.length && (!cond || !doppelt)) {
				if(head.test(listen[i].head)) {
					if(!cond) {
						cond = true;
					} else {
						doppelt = true;
					}
				}
				i++;
			}
			return(cond && !doppelt);
		},
		writable:false,
		enumerable:false,
		configurable:false,
	},
});